unit UNetDrive;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, Buttons;

resourceString
  CTITLE_DRIVE = 'hCu';
  CTITLE_PATH = 'lbg[NpX';
  CTITLE_COMMENT = 'Rg';

	ERR_ACCESS_DENIED = 'lbg[N\[Xւ̃ANZXۂ܂B';
  ERR_ALREADY_ASSIGNED = '[JfoCX́AłɃlbg[N\[XɐڑĂ܂B';
	ERR_BAD_DEV_TYPE = '[JfoCX̎ނƃlbg[N\[X̎ނvĂ܂B';
  ERR_BAD_NET_NAME = '\[XA邢͎w肳ꂽ\[X܂B';
  ERR_BAD_PROFILE = '[U[̃vt@Č`܂B';
  ERR_BAD_PROVIDER = 'w肳ꂽĺAǂ̃voC_[ɂv܂B';
  ERR_BUSY = '[^[܂̓voC_́A̓r̉\ArW[ԂłB';
  ERR_CANCELLED = 'Ăяõ\[XɂĎ܂B';
  ERR_CANNOT_OPEN_PROFILE = 'VXéAȑOƓڑs߂Ƀ[U[̃vt@CI[v邱Ƃł܂B';
  ERR_DEVICE_ALREADY_REMEMBERED = 'w肵foCX̃GgłɃ[U[̃vt@Cɑ݂܂B';
  ERR_EXTENDED_ERROR = 'lbg[NŗL̃G[܂B';
  ERR_INVALID_PASSWORD = 'w肳ꂽpX[hłB';
  ERR_NO_NET_OR_BAD_PATH = 'lbg[NvfJnĂ܂B܂́Aw肳ꂽOg܂B';
  ERR_NO_NETWORK = 'lbg[N݂܂B';

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    btnAdd: TBitBtn;
    btnDel: TBitBtn;
    btnList: TBitBtn;
    btnExit: TBitBtn;
    cmbDrive: TComboBox;
    edtNetworkPath: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    edtUser: TEdit;
    edtPass: TEdit;
    lblUser: TLabel;
    lblPass: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnListClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
  private
    { Private 錾 }
  public
    procedure Refresh;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  Math;

const
  C_DRIVE = 0;
  C_PATH = 1;
  C_COMMENT = 2;

// WNetnAPIG[֐
procedure NetErrorProc(err: DWORD);
var
	s: String;
begin
	case err of
  	ERROR_ACCESS_DENIED:					s := ERR_ACCESS_DENIED;
		ERROR_ALREADY_ASSIGNED:				s := ERR_ALREADY_ASSIGNED;
    ERROR_BAD_DEV_TYPE: 					s := ERR_BAD_DEV_TYPE;
    ERROR_BAD_NET_NAME:						s := ERR_BAD_NET_NAME;
    ERROR_BAD_PROFILE:						s := ERR_BAD_PROFILE;
    ERROR_BAD_PROVIDER:						s := ERR_BAD_PROVIDER;
    ERROR_BUSY:										s := ERR_BUSY;
    ERROR_CANCELLED:							s := ERR_CANCELLED;
    ERROR_CANNOT_OPEN_PROFILE:		s := ERR_CANNOT_OPEN_PROFILE;
    ERROR_DEVICE_ALREADY_REMEMBERED:	s := ERR_DEVICE_ALREADY_REMEMBERED;
    ERROR_EXTENDED_ERROR:					s := ERR_EXTENDED_ERROR;
    ERROR_INVALID_PASSWORD:				s := ERR_INVALID_PASSWORD;
    ERROR_NO_NET_OR_BAD_PATH:			s := ERR_NO_NET_OR_BAD_PATH;
    ERROR_NO_NETWORK:							s := ERR_NO_NETWORK;
  	else s := IntToStr(err);
	end;
  MessageDlg(s, mtError, [mbOk], 0);
end;

// lbg[NhCů蓖
procedure AddNetworkDrive(Drive, UNC, Comment, Password, UserName: string);
var
	NetResource: TNetResource;
{$IFDEF UNICODE}
  user, pass: PWideChar;
{$ELSE}
  user, pass: PChar;
{$ENDIF}
begin
{$IFDEF UNICODE}
	with NetResource do
  begin
  	dwType := RESOURCETYPE_DISK;
    lpLocalName := PWideChar(Drive);
    lpRemoteName := PWideChar(UNC);
    lpComment := PWideChar(Comment);
    lpProvider := nil;
  end;
  if (Password = '') then
    pass := nil
  else
    pass := PWideChar(password);
  if (UserName = '') then
    user := nil
  else
    user := PWideChar(UserName);
{$ELSE}
	with NetResource do
  begin
  	dwType := RESOURCETYPE_DISK;
    lpLocalName := PChar(Drive);
    lpRemoteName := PChar(UNC);
    lpComment := PChar(Comment);
    lpProvider := nil;
  end;
  if (Password = '') then
    pass := nil
  else
    pass := PChar(password);
  if (UserName = '') then
    user := nil
  else
    user := PChar(UserName);
{$ENDIF}
  if (WNetAddConnection2(NetResource, pass, user, 0) <> NO_ERROR) then
  begin
  	NetErrorProc(GetLastError);
  end;
end;

// lbg[NhCu̐ڑ
procedure RemoveNetworkDrive(Drive: string);
begin
  if (Drive = '') then exit;
{$IFDEF UNICODE}
	WNetCancelConnection2(PWideChar(Drive), 0, true);
//	WNetCancelConnection2(PWideChar(Drive[1]), 0, false);
{$ELSE}
	WNetCancelConnection2(PChar(Drive), 0, false);
{$ENDIF}
end;

// lbg[NhCu̐ڑ̗
procedure EnumNetworkDrive(var sg: TStringGrid);
type
  PNetResourceArray = ^TNetResourceArray;
  TNetResourceArray = array[0..MaxInt div SizeOf(TNetResource) - 1] of TNetResource;
const
	dwScope: DWORD = RESOURCE_CONNECTED;
  dwType: DWORD	= RESOURCETYPE_DISK;
  dwUsage: DWORD = RESOURCEUSAGE_CONNECTABLE;
var
	NetResource: TNetResource;
  NetHandle: THandle;
  i: integer;
  NetResult: DWORD;

  NetResources: PNetResourceArray;
  BufSize: Integer;
  Entries, Size: LongWord;
  RowCnt: integer;
begin
  with NetResource do
  begin
  	dwType := RESOURCETYPE_DISK;
    lpLocalName := nil;
    lpRemoteName := nil;
    lpComment := nil;
    lpProvider := nil;
  end;
  if WNetOpenEnum(dwScope, dwType, dwUsage, @NetResource, NetHandle) <> NO_ERROR then
  begin
  	NetErrorProc(GetLastError);
    exit;
  end;
  RowCnt := 0;
  try
    BufSize := 50 * SizeOf(TNetResource);
    GetMem(NetResources, BufSize);
    try
      while True do
      begin
        Entries := $FFFFFFFF;
        Size := BufSize;

        NetResult := WNetEnumResource(NetHandle, Entries, NetResources, Size);
        if (NetResult = ERROR_MORE_DATA) then
        begin
          BufSize := Size;
          ReallocMem(NetResources, BufSize);
          continue;
        end;
        if (NetResult <> NO_ERROR) then
        begin
          if (NetResult <> ERROR_NO_MORE_ITEMS) then
            NetErrorProc(GetLastError);
          exit;
        end;

        for i := 0 to Entries - 1 do
          with NetResources^[I] do
            if (lpLocalName <> nil) and (string(lpLocalName) <> '') then
            begin
              inc(RowCnt);
              sg.Cells[C_DRIVE, RowCnt] := String(lpLocalName);
              sg.Cells[C_PATH, RowCnt] := String(lpRemoteName);
              sg.Cells[C_COMMENT, RowCnt] := String(lpComment);
            end;
      end;
    finally
      FreeMem(NetResources, BufSize);
    end;
  finally
    WNetCloseEnum(NetHandle);
    sg.RowCount := Max(RowCnt +1, 2);
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	with StringGrid1 do
  begin
  	Cells[C_DRIVE, 0] := CTITLE_DRIVE;
    Cells[C_PATH, 0] := CTITLE_PATH;
    Cells[C_COMMENT, 0] := CTITLE_COMMENT;
  end;
  Refresh;
end;

procedure TForm1.Refresh;
var
  sDrv: string;
  i: integer;
begin
  cmbDrive.Items.Clear;
  edtNetworkPath.Clear;
  EnumNetworkDrive(StringGrid1);

  for i := ord('A') to ord('Z') do
  begin
    sDrv := chr(i) +':';
    if (StringGrid1.Cols[C_DRIVE].IndexOf(sDrv) = -1) then
		  cmbDrive.Items.Add(sDrv);
  end;
end;

procedure TForm1.btnAddClick(Sender: TObject);
begin
	AddNetworkDrive(cmbDrive.Text, edtNetworkPath.Text, '', edtPass.Text, edtUser.Text);
  Refresh;
end;

procedure TForm1.btnDelClick(Sender: TObject);
begin
  with StringGrid1 do
	  RemoveNetworkDrive(Cells[C_DRIVE, Row]);
  Refresh;
end;

procedure TForm1.btnListClick(Sender: TObject);
begin
	EnumNetworkDrive(StringGrid1);
end;

procedure TForm1.btnExitClick(Sender: TObject);
begin
	Close;
end;

end.
